<?php

namespace Database\Seeders;

use App\Models\Package;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class PackageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // VIP Packages
        Package::create([
            'name' => 'VIP Basic',
            'slug' => 'vip-basic',
            'description' => 'Get started with our basic VIP package and enjoy exclusive benefits in-game.',
            'price' => 9.99,
            'type' => 'vip',
            'features' => [
                'VIP tag in chat',
                'Access to VIP only commands',
                'Extra starting money ($10,000)',
                '5 inventory slots',
                'Access to VIP vehicles',
            ],
            'image_path' => 'images/store/vip-basic.jpg',
            'is_active' => true,
            'sort_order' => 1,
        ]);

        Package::create([
            'name' => 'VIP Plus',
            'slug' => 'vip-plus',
            'description' => 'Upgrade your experience with our Plus VIP package offering more benefits and features.',
            'price' => 19.99,
            'type' => 'vip',
            'features' => [
                'VIP+ tag in chat',
                'All Basic VIP benefits',
                'Extra starting money ($25,000)',
                '10 inventory slots',
                'Access to exclusive VIP+ vehicles',
                'Priority server queue',
            ],
            'image_path' => 'images/store/vip-plus.jpg',
            'is_active' => true,
            'sort_order' => 2,
        ]);

        Package::create([
            'name' => 'Elite VIP',
            'slug' => 'elite-vip',
            'description' => 'Our premium VIP package with all the bells and whistles for the ultimate DarkRP experience.',
            'price' => 49.99,
            'type' => 'vip',
            'features' => [
                'Elite VIP tag in chat',
                'All VIP+ benefits',
                'Extra starting money ($100,000)',
                '20 inventory slots',
                'Access to exclusive Elite vehicles and weapons',
                'Priority server queue',
                'Custom player model',
                'Custom chat color',
                'Monthly bonus rewards',
            ],
            'image_path' => 'images/store/elite-vip.jpg',
            'is_active' => true,
            'sort_order' => 3,
        ]);

        // Money Packages
        Package::create([
            'name' => 'Small Money Package',
            'slug' => 'small-money-package',
            'description' => 'Boost your in-game wallet with this small money package.',
            'price' => 4.99,
            'type' => 'money',
            'features' => [
                '$250,000 in-game currency',
                'Instant delivery',
                'One-time purchase',
            ],
            'image_path' => 'images/store/money-small.jpg',
            'is_active' => true,
            'sort_order' => 1,
        ]);

        Package::create([
            'name' => 'Medium Money Package',
            'slug' => 'medium-money-package',
            'description' => 'Get a significant boost to your in-game finances with this medium money package.',
            'price' => 9.99,
            'type' => 'money',
            'features' => [
                '$750,000 in-game currency',
                'Instant delivery',
                'One-time purchase',
                'Bonus: $50,000 extra',
            ],
            'image_path' => 'images/store/money-medium.jpg',
            'is_active' => true,
            'sort_order' => 2,
        ]);

        Package::create([
            'name' => 'Large Money Package',
            'slug' => 'large-money-package',
            'description' => 'Become an instant millionaire in-game with our large money package.',
            'price' => 24.99,
            'type' => 'money',
            'features' => [
                '$2,000,000 in-game currency',
                'Instant delivery',
                'One-time purchase',
                'Bonus: $250,000 extra',
                'Exclusive money bag accessory',
            ],
            'image_path' => 'images/store/money-large.jpg',
            'is_active' => true,
            'sort_order' => 3,
        ]);

        // Job Packages
        Package::create([
            'name' => 'Police Chief Package',
            'slug' => 'police-chief-package',
            'description' => 'Unlock the exclusive Police Chief job and enforce the law in the server.',
            'price' => 14.99,
            'type' => 'job',
            'features' => [
                'Unlock Police Chief job permanently',
                'Special police weapons and equipment',
                'Police station access',
                'Authority to arrest players',
                'Access to police vehicles',
            ],
            'image_path' => 'images/store/job-police.jpg',
            'is_active' => true,
            'sort_order' => 1,
        ]);

        Package::create([
            'name' => 'Mob Boss Package',
            'slug' => 'mob-boss-package',
            'description' => 'Become the most feared criminal in the city with this exclusive Mob Boss job package.',
            'price' => 19.99,
            'type' => 'job',
            'features' => [
                'Unlock Mob Boss job permanently',
                'Access to special weapons',
                'Ability to recruit gang members',
                'Hidden underground base',
                'Special mob vehicles',
            ],
            'image_path' => 'images/store/job-mob.jpg',
            'is_active' => true,
            'sort_order' => 2,
        ]);

        Package::create([
            'name' => 'Gun Dealer Package',
            'slug' => 'gun-dealer-package',
            'description' => 'Control the weapons trade with this exclusive Gun Dealer job package.',
            'price' => 12.99,
            'type' => 'job',
            'features' => [
                'Unlock Gun Dealer job permanently',
                'Access to all weapons for sale',
                'Increased profit margins',
                'Special gun store property',
                'Weapon crafting abilities',
            ],
            'image_path' => 'images/store/job-gun-dealer.jpg',
            'is_active' => true,
            'sort_order' => 3,
        ]);
    }
}